package ibase.webitm.ejb.vhb.msq1;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class ApprovedRate extends ValidatorEJB {
    String usersiteCode = "";
    E12GenericUtility genericUtility = new E12GenericUtility();

    public ApprovedRate(UserInfoBean userInfoBean) {
        setUserInfo(userInfoBean);
        userInfoBean = getUserInfo();
        usersiteCode = userInfoBean.getSiteCode();
        BaseLogger.log("3", getUserInfo(), null, "usersiteCode : " + usersiteCode);
    }

    public HashMap<String, ArrayList<String>> getLastThreeQuotationRates(String itemCode) throws ITMException, SQLException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        LinkedHashMap<String, ArrayList<String>> quotationRatesMap = new LinkedHashMap<>();
        int count = 0;
        String customerCode = "" , quotNo = "" , addDate = "" ,aprvRate = "" , quantity="";
        String sql = "select cust_code , quot_no , created_date , item_code , approved_rate , quantity from item_rate_hist where item_code= ?  AND created_date IS NOT NULL ORDER BY  created_date desc limit 5";
        try {
            BaseLogger.log("3", getUserInfo(), null, "Fetching last 5 quotation rates for item_code: " + itemCode);

            conn = getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, itemCode); 
            rs = pstmt.executeQuery();

            while (rs.next())
            {
                ArrayList<String> quotationDetails = new ArrayList<>();
                customerCode = checkNull(rs.getString("cust_code"));
                quotNo = checkNull(rs.getString("quot_no"));
                addDate = checkNull(rs.getString("created_date"));
                itemCode =  checkNull(rs.getString("item_code"));
                aprvRate = checkNull(rs.getString("approved_rate"));
                quantity = checkNull(rs.getString("quantity"));
  
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());
                java.util.Date addDateUtil = simpleDateFormat.parse(addDate);
                SimpleDateFormat displayFormat = new SimpleDateFormat("dd/MM/yy");
                String formattedAddDate = displayFormat.format(addDateUtil);

                quotationDetails.add(customerCode);
                quotationDetails.add(quotNo);
                quotationDetails.add(formattedAddDate);
                quotationDetails.add(itemCode);
                quotationDetails.add(aprvRate);
                quotationDetails.add(quantity);

                quotationRatesMap.put(String.valueOf(count), quotationDetails);
                count++;
            }

        } 
        catch (Exception e) 
        {
            BaseLogger.log("3", getUserInfo(), null, "Exception in getLastFiveQuotationRates: " + e.getMessage());
            throw new ITMException(e);
        }
        finally
        {

            if (rs != null) {
                rs.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }

        return quotationRatesMap;
    }

    private String checkNull(String str)
    {
        if (str == null) {
            return "";
        } else {
            return str;
        }
    }
}
